# IAR - Extensão Chrome

Extensão do Chrome para otimização de copy com Inteligência Artificial.

## Funcionalidades

- ✨ **Análise de Copy**: Analise e otimize textos diretamente nas páginas
- 📱 **Integração Instagram**: Botões de análise direto no Instagram
- 🎯 **Geração de Copy**: Crie bios, posts, legendas e anúncios
- 💬 **CTAs Personalizados**: Gere chamadas para ação de alto impacto
- 🔄 **Seleção de Texto**: Botão flutuante ao selecionar texto em qualquer página

## Instalação para Desenvolvimento

1. Abra o Chrome e vá para `chrome://extensions/`
2. Ative o "Modo do desenvolvedor" no canto superior direito
3. Clique em "Carregar sem compactação"
4. Selecione a pasta `chrome-extension`
5. A extensão será instalada e aparecerá na barra de ferramentas

## Instalação para Usuários

1. Baixe o arquivo `.zip` da extensão
2. Extraia o conteúdo em uma pasta
3. Abra o Chrome e vá para `chrome://extensions/`
4. Ative o "Modo do desenvolvedor"
5. Clique em "Carregar sem compactação"
6. Selecione a pasta extraída

## Como Usar

### Análise Rápida
1. Selecione qualquer texto em uma página
2. Clique no botão roxo flutuante que aparece
3. A extensão abrirá com o texto pronto para análise

### No Instagram
1. Navegue até um perfil ou post no Instagram
2. Clique nos botões "Analisar com IAR" que aparecem
3. Receba análise e sugestões de melhoria

### Menu da Extensão
1. Clique no ícone da extensão na barra de ferramentas
2. Escolha entre as abas:
   - **Analisar**: Cole ou selecione texto para análise
   - **Gerar Copy**: Crie novos textos otimizados
   - **CTAs**: Gere chamadas para ação

## Autenticação

Para usar a extensão, você precisa fazer login com sua conta IAR:

1. Clique no ícone da extensão
2. Clique em "Fazer Login"
3. Faça login no site do IAR
4. A extensão será automaticamente autenticada

## Estrutura de Arquivos

```
chrome-extension/
├── manifest.json          # Configuração da extensão
├── background.js          # Service worker
├── icons/                 # Ícones da extensão
│   ├── icon16.png
│   ├── icon32.png
│   ├── icon48.png
│   └── icon128.png
├── popup/                 # Interface da extensão
│   ├── popup.html
│   ├── popup.css
│   └── popup.js
└── content/              # Scripts injetados nas páginas
    ├── content.js
    └── content.css
```

## Permissões

A extensão solicita as seguintes permissões:

- **activeTab**: Para acessar o conteúdo da aba ativa
- **storage**: Para armazenar configurações e token de autenticação
- **scripting**: Para injetar scripts nas páginas
- **host_permissions**: Para funcionar no Instagram e outras páginas

## Suporte

Para suporte, visite: https://iar-saas.com/suporte

## Versão

Versão atual: 1.0.0
