// Background Service Worker
console.log('IAR Extension: Background service worker started');

// Listen for extension installation
chrome.runtime.onInstalled.addListener((details) => {
  if (details.reason === 'install') {
    console.log('IAR Extension installed');
    // Open welcome page
    chrome.tabs.create({
      url: 'https://3000-ixfo7j07jg54yt7gqvawy-6952e536.manusvm.computer?welcome=true'
    });
  } else if (details.reason === 'update') {
    console.log('IAR Extension updated');
  }
});

// Listen for messages from content scripts and popup
chrome.runtime.onMessage.addListener((request, sender, sendResponse) => {
  console.log('Background received message:', request);

  if (request.action === 'analyzeText') {
    handleAnalyzeText(request, sender);
  } else if (request.action === 'generateCopy') {
    handleGenerateCopy(request, sender);
  } else if (request.action === 'authenticate') {
    handleAuthentication(request, sender);
  }

  return true; // Keep message channel open for async response
});

// Handle text analysis
async function handleAnalyzeText(request, sender) {
  try {
    const { text, type } = request;
    
    // Open popup with the text
    chrome.action.openPopup();
    
    // Send text to popup
    setTimeout(() => {
      chrome.runtime.sendMessage({
        action: 'textSelected',
        text: text,
        type: type
      });
    }, 500);
    
  } catch (error) {
    console.error('Analysis error:', error);
  }
}

// Handle copy generation
async function handleGenerateCopy(request, sender) {
  try {
    // This would call your API
    console.log('Generating copy:', request);
  } catch (error) {
    console.error('Generation error:', error);
  }
}

// Handle authentication
async function handleAuthentication(request, sender) {
  try {
    const { token, user } = request;
    
    // Store auth data
    await chrome.storage.local.set({
      authToken: token,
      user: user
    });
    
    console.log('User authenticated:', user);
  } catch (error) {
    console.error('Authentication error:', error);
  }
}

// Context menu
chrome.runtime.onInstalled.addListener(() => {
  chrome.contextMenus.create({
    id: 'analyzeWithIAR',
    title: 'Analisar com IAR',
    contexts: ['selection']
  });
});

// Handle context menu clicks
chrome.contextMenus.onClicked.addListener((info, tab) => {
  if (info.menuItemId === 'analyzeWithIAR') {
    chrome.runtime.sendMessage({
      action: 'textSelected',
      text: info.selectionText
    });
    chrome.action.openPopup();
  }
});

// Keep service worker alive
let keepAliveInterval;

function keepAlive() {
  keepAliveInterval = setInterval(() => {
    chrome.runtime.getPlatformInfo(() => {
      // Just to keep the service worker alive
    });
  }, 20000); // Every 20 seconds
}

keepAlive();

// Clean up on suspend
chrome.runtime.onSuspend.addListener(() => {
  if (keepAliveInterval) {
    clearInterval(keepAliveInterval);
  }
});
