// Diagnostic form handler
document.addEventListener('DOMContentLoaded', async () => {
  const form = document.getElementById('diagnosticForm');
  const skipButton = document.getElementById('skipDiagnostic');
  
  // Load existing profile if editing
  const result = await chrome.storage.local.get(['userProfile']);
  if (result.userProfile) {
    // Pre-fill form with existing data
    document.getElementById('niche').value = result.userProfile.niche || '';
    document.getElementById('promise').value = result.userProfile.promise || '';
    document.getElementById('transformation').value = result.userProfile.transformation || '';
    document.getElementById('tone').value = result.userProfile.tone || '';
    document.getElementById('persona').value = result.userProfile.persona || '';
    
    // Change button text to indicate editing
    const submitBtn = form.querySelector('button[type="submit"]');
    if (submitBtn) {
      submitBtn.textContent = '💾 Atualizar Perfil';
    }
  }

  // Handle form submission
  form.addEventListener('submit', async (e) => {
    e.preventDefault();

    const formData = new FormData(form);
    const profile = {
      niche: formData.get('niche'),
      promise: formData.get('promise'),
      transformation: formData.get('transformation'),
      tone: formData.get('tone'),
      persona: formData.get('persona'),
      completedAt: new Date().toISOString()
    };

    try {
      // Save profile to chrome storage
      await chrome.storage.local.set({ userProfile: profile });

      // Show success message
      showSuccess();

      // Redirect to main popup after 1.5 seconds
      setTimeout(() => {
        window.location.href = 'popup.html';
      }, 1500);
    } catch (error) {
      console.error('Error saving profile:', error);
      alert('Erro ao salvar perfil. Tente novamente.');
    }
  });

  // Handle skip button
  skipButton.addEventListener('click', () => {
    if (confirm('Tem certeza? O diagnóstico personaliza todo o conteúdo para você.')) {
      window.location.href = 'popup.html';
    }
  });
});

function showSuccess() {
  const form = document.getElementById('diagnosticForm');
  form.innerHTML = `
    <div style="text-align: center; padding: 40px 20px;">
      <div style="font-size: 48px; margin-bottom: 16px;">✅</div>
      <h3 style="color: #1f2937; margin-bottom: 8px;">Perfil salvo com sucesso!</h3>
      <p style="color: #6b7280;">Agora todo conteúdo será personalizado para você.</p>
    </div>
  `;
}
